<?php
	include("class/pData.class.php");
	include("class/pDraw.class.php");
	include("class/pRadar.class.php");
	include("class/pImage.class.php");
	$chartData = new pData();
	$chartData->addPoints(array($_GET['uN'],$_GET['uP'],$_GET['mPr'],$_GET['mPe'],$_GET['rS']),"Score");
	$chartData->setSerieDescription("Score","Vous");
	$chartData->setPalette("Score",array("R"=>200,"G"=>25,"B"=>150));
	
	$chartData->addPoints(array("Urgence négative","Urgence Positive","Manque de préméditation","Manque de persévérance","Recherche de sensation"),"Labels");
	$chartData->setAbscissa("Labels");
	
	$chartPicture = new pImage(700,400,$chartData);
	
	$chartSettings = array("R"=>179, "G"=>217, "B"=>91, "Dash"=>1, "DashR"=>199, "DashG"=>237, "DashB"=>111);
	$chartPicture->drawFilledRectangle(0,0,700,400,$chartSettings);
	
	$chartSettings = array("StartR"=>194, "StartG"=>231, "StartB"=>44, "EndR"=>43, "EndG"=>107, "EndB"=>58, "Alpha"=>50);
	$chartPicture->drawGradientArea(0,0,700,400,DIRECTION_VERTICAL,$chartSettings);
	
	$chartPicture->drawRectangle(0,0,699,399,array("R"=>0,"G"=>0,"B"=>0));
	
	$chartPicture->setFontProperties(array("FontName"=>"fonts/Forgotte.ttf","FontSize"=>16,"R"=>80,"G"=>80,"B"=>80));
	$chartPicture->setShadow(TRUE,array("X"=>2,"Y"=>2,"R"=>0,"G"=>0,"B"=>0,"Alpha"=>10));
	
	$splitChart = new pRadar();
	
	$chartPicture->setGraphArea(75,0,680,380);
	$options = array("Layout"=>RADAR_LAYOUT_CIRCLE, "LabelPos"=>RADAR_LABELS_HORIZONTAL, "BackgroundGradient"=>array("StartR"=>255,"StartG"=>255,"StartB"=>255,"StartAlpha"=>50,"EndR"=>32,"EndG"=>109,"EndB"=>174,"EndAlpha"=>30), "FixedMax"=>16, "DrawAxisValues"=>false, "SegmentHeight"=>4, "WriteValues"=>true);
	$splitChart->drawRadar($chartPicture,$chartData,$options);
	
	$chartPicture->Stroke();